# simple models, level 2 determined by BIC/AIC; RE: canton, region, party
set.seed(123)
sim.block <- sim(modeL,N.sim)
beta.a.block <- fixef(sim.block)
ctnr.a.block <- ranef(sim.block)$cantonnr[,,1]
region.a.block <- ranef(sim.block)$region[,,1]
party.a.block <- ranef(sim.block)$party[,,1]

# party.a.block should be 1000*10


data3 <- read.dta("Context Data.dta")

x2.1 <- data3$german
x2.2 <- data3$romancatholic
x2.3 <- data3$gdp_capita
x2.4 <- data3$university
x2.5 <- data3$NR_left_2011
x2.6 <- data3$NR_right_2011


ind.contr.latent <- rbind(t(party.a.block), t(party.a.block), t(party.a.block), t(party.a.block), t(party.a.block), t(party.a.block), t(party.a.block), t(party.a.block), t(party.a.block), t(party.a.block),t(party.a.block), t(party.a.block), t(party.a.block), t(party.a.block), t(party.a.block), t(party.a.block), t(party.a.block), t(party.a.block), t(party.a.block), t(party.a.block), t(party.a.block), t(party.a.block), t(party.a.block),t(party.a.block),t(party.a.block),t(party.a.block))

#cat("Party contribution (to the latent variable) calculated.\n")
	

cant.pointer <- rep(1,10)
	for (j in 2:26){
		a <- rep(j,10)
		cant.pointer <- c(cant.pointer,a)		
	}


region.pointer <- c(rep(4,10),rep(2,10),rep(6,10),rep(6,10),rep(6,10),rep(6,10),rep(6,10),rep(5,10),rep(6,10),rep(2,10),rep(2,10),rep(3,10),rep(3,10),rep(5,10),rep(5,10),rep(5,10),rep(5,10),rep(5,10),rep(3,10),rep(5,10),rep(7,10),rep(1,10),rep(1,10),rep(2,10),rep(1,10),rep(2,10))

cant.re.contr.latent <- matrix(NA,260,1000)

for (i in 1:260){
	 cant.re.contr.latent[i,] <- t(ctnr.a.block[,cant.pointer[i]] + region.a.block[,region.pointer[i]])
	}


if (model.spec==1){
	X.cant <- cbind(1,x2.1)	
	}
if (model.spec==2){
	X.cant <- cbind(1,x2.2)	
	}
if (model.spec==4){
	X.cant <- cbind(1,x2.4)	
	}
if (model.spec==5){
	X.cant <- cbind(1,x2.5)	
	}
if (model.spec==6){
	X.cant <- cbind(1,x2.6)	
	}
if (model.spec==9){
	X.cant <- cbind(1,x2.1,x2.4)	
	}
if (model.spec==10){
	X.cant <- cbind(1,x2.1,x2.5)	
	}
if (model.spec==13){
	X.cant <- cbind(1,x2.2,x2.4)	
	}
if (model.spec==20){
	X.cant <- cbind(1,x2.4,x2.6)	
	}
if (model.spec==64){
	X.cant <- rep(1,26)	
	}

# this is short (only 26, not 260)
cant.fe.contr.latent.sh <- matrix(NA,26,1000)
for (i in 1:26){
	 cant.fe.contr.latent.sh <- X.cant %*% t(beta.a.block)
	}


cant.fe.contr.latent <- rbind(cant.fe.contr.latent.sh[1,], cant.fe.contr.latent.sh[1,], cant.fe.contr.latent.sh[1,], cant.fe.contr.latent.sh[1,], cant.fe.contr.latent.sh[1,], cant.fe.contr.latent.sh[1,], cant.fe.contr.latent.sh[1,], cant.fe.contr.latent.sh[1,], cant.fe.contr.latent.sh[1,],cant.fe.contr.latent.sh[1,])

	for (j in 2:26){
		a <- rbind(cant.fe.contr.latent.sh[j,], cant.fe.contr.latent.sh[j,], cant.fe.contr.latent.sh[j,], cant.fe.contr.latent.sh[j,], cant.fe.contr.latent.sh[j,], cant.fe.contr.latent.sh[j,], cant.fe.contr.latent.sh[j,], cant.fe.contr.latent.sh[j,], cant.fe.contr.latent.sh[j,], cant.fe.contr.latent.sh[j,])
		cant.fe.contr.latent <- rbind(cant.fe.contr.latent,a)		
			}

#cat("Cantonal contribution (to the latent variable) calculated.\n")
	
# combining the latent canton and the latent individual

synth.cant.ind <- cant.fe.contr.latent + ind.contr.latent 
pred.uncert <- pnorm(synth.cant.ind)

#cat("Cantonal and individual contribution combined - ready for post-stratification step.\n")


# post-stratification step
dat.w <- read.dta("Gov_weight.dta")

# party names
#fdp, cvp. sp, svp, gps, csp, glp, bdp, lega, mcg

dat.w[1,]
party.shares <- cbind(dat.w[,5], dat.w[,7], dat.w[,9],  dat.w[,11], dat.w[,15], dat.w[,17], c(rep(0,26)), dat.w[,13], dat.w[,19], c(rep(0,26)))
#						fdp			cvp			sp			svp			gps			csp			glp			bdp			lega		mcg
party.shares.vector <- as.vector(t(party.shares))


cantonal.pred <- pred.uncert*party.shares.vector

cant.pred.mrp <- matrix(NA,26,1000)

for (i in 1:26){
		taker <- c((i*10-9):(i*10))
		cant.pred.mrp[i,] <- colSums(cantonal.pred[taker,])
	}

cantonal.support <- cant.pred.mrp

cat("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n Preferences have been simulated for this policy!\n")
#writeLines(paste("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"))
writeLines(paste(" Response Model Specification",model.spec,"is the base.", sep=" "))
#writeLines((paste(" The process took:",round(time1[3],1),"seconds.", sep=" ")))
writeLines(paste("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"))

